// ABX  Place and orient objects along spline  http://news.povray.org/povray.general/message/%3Cttoenucoq6fcgkun57la24s9ia4ij5o573%404ax.com%3E/#%3Cttoenucoq6fcgkun57la24s9ia4ij5o573%404ax.com%3E

#version 3.7;

#declare RAD = 4; 
                
global_settings {
        #declare a_g = 1;
        assumed_gamma a_g
        max_trace_level 5
        subsurface {radiosity on samples 200,200}
        noise_generator 2  
        #if(RAD > 0)
                radiosity {
                        pretrace_start 0.08
                        pretrace_end   0.04/RAD
                        count 60*RAD                
                        nearest_count min (20, RAD)      
                        error_bound 2/RAD
                        low_error_factor 0.5      
                        recursion_limit 1      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1      
                        adc_bailout 0.005
                        normal on
                        media off
                        always_sample off
                }
        #end
}

camera { 
        angle 31*image_width/image_height*0.75
        location  <0,0,-1>
        right     x*image_width/image_height
        look_at   <0,0.05,0>
}

#include "transforms.inc"
#include "shapes.inc"
#include "strings.inc"

#macro Time_To_Length_Converter (Spline, Min, Max, Accuracy)

#local Conversion = 
function {
        spline {
                #local Last = Spline (Min);
                #local Length = 0;
                #local C = Min;
                #while (C <= Max)
                        #local C = min (C, Max);
                        #local Point = Spline (C);
                        #local Length = Length+vlength (Point-Last);
                        #local Last = Point;
                        C , <1,0,0>*Length
                        #local C = C+Accuracy;
                #end
        }
}

function (T) {Conversion (T).x}

#end

#macro Spline_With_Linear_Movement (Spline, Min, Max, Accuracy)

spline {
        #local Last = Spline(Min);
        #local Length = 0;
        #local C = Min;
        #while (C <= Max)
                #local C = min (C, Max);
                #local Point = Spline (C);
                #local Length = Length+vlength (Point-Last);
                #local Last = Point;
                Length, Point+<0,0,0>
                #local C = C+Accuracy;
        #end
}

#end

#declare fac = 0.5;
#declare rs = seed (2338);
#declare sca = rand (rs);
#declare sca2 = 0.5;

#declare MySpline = 
spline {
        cubic_spline
        -0.125,<sca*-1,0,0*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        0,     <sca*0,0,1*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        0.125, <sca*1,0,0*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        0.25,  <sca*2,0,-1*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        0.375, <sca*3,0,0*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        0.5,   <sca*4,0,1*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        0.625, <sca*5,0,0*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac
        0.75,  <sca*6,0,-1*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        0.875, <sca*7,0,0*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        1,     <sca*8,0,1*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac,
        1.125, <sca*9,0,0*sca2>+<rand (rs),0.5*rand (rs),rand (rs)>*fac
}

#declare MySplineLinear = Spline_With_Linear_Movement (MySpline, 0, 1, 0.001);
#declare f_MySplineLength = Time_To_Length_Converter (MySpline, 0, 1, 0.001);
#declare MySplineLength = f_MySplineLength (1);

#declare MyObject = 
union {
        union {
                torus {
                        0.425, 0.075
                        rotate < 0.0, 0.0, 90.0 >
                        scale < 4.5, 1.125, 1.125 >
                }
                torus {
                        0.425, 0.075
                        rotate < 0.0, 0.0, 90.0 >
                        translate < -0.25, 0.0, 0.0 >
                }
                torus {
                        0.425, 0.075
                        rotate < 0.0, 0.0, 90.0 >
                        translate < 0.25, 0.0, 0.0 >
                }
                texture {
                        pigment {
                                onion
                                color_map {
                                        [0 color rgb 1]
                                        [1 color rgb <0.075,0.0751,0.075>]
                                }
                                rotate <0,0,90>
                                scale 0.6
                        }
                        normal {
                                granite 0.15 
                                scale 1
                        }
                        finish {phong 0.1}
                }
        }
        union {
                cylinder {<-0.323,0,0>, <-0.322,0,0>, 0.425}
                cylinder {< 0.323,0,0>, < 0.322,0,0>, 0.425}
                texture {
                        pigment {
                                onion
                                color_map {
                                        [0      rgbt <0.7764706,0.8941176,0.545098,0.85>]
                                        [0.65   rgbt <0.7764706,0.8941176,0.545098,0.85>]
                                        [1      rgbt <0.075,0.0755,0.075,0.35>]
                                }
                                rotate <0,0,90>
                                scale 0.52
                        }
                        normal {
                                granite 0.15 
                                scale 1
                        }
                        finish {phong 0.1}
                }
        }
        sphere {
                <0,0,0>, 0.315
                scale <1,1,1>
                texture {
                        pigment {
                                onion
                                color_map {
                                        [0      rgb <0.5019608,0.772549,0.227451>*0.9]
                                        [1      rgb <0.5019608,0.772549,0.227451>*1.1]
                                }
                                rotate <0,0,90>
                                scale 0.52
                        }
                        normal {
                                granite 0.75 
                                scale 0.5
                        }
                        finish {phong 0.1}
                }
        }
        scale 0.27
        rotate z*90
}

#declare Step = MySplineLength*0.05;

#declare All =
union {
        #declare Count = 0;
        #while (Count <= MySplineLength-Step)
                object {
                        MyObject
                        pigment {color rgb <1,0.3,0.7>}
                        finish {
                        	specular albedo 1
                        	metallic
                        	roughness 0.025
                        	diffuse 0.4
                        	brilliance 2
                        	reflection {0, 1 metallic}
                        	conserve_energy
                        	irid {0.35 thickness 0.1 turbulence 0.5} 
                                ambient 0
                        }
                        Spline_Trans (MySplineLinear, Count, y, 0.1, 0.1)
                }
                #declare Count = Count+Step;
        #end
        rotate x*90
}

object{
        Center_Object (All, 1)
        translate z*5
}

sphere {
        0, 1000
        pigment {
                image_map {
                        hdr "kitchen_probe2.hdr"
                        gamma 2.2
                        map_type 1
                        interpolate 2
                }
        }
        finish {emission rgb 0.05}
        no_image
}

background {
        color rgb <0.1843137,0.4666667,0.5490196>*0.5
}
